#pragma once

#include "dns_zones_replica.h"
#include "service_feedback.h"
#include "zones_state_coordinator.h"

#include <infra/libs/yp_dns/dynamic_zones/protos/configs/zones_manager.pb.h>

#include <infra/libs/yp_dns/zone/zone.h>

#include <infra/libs/logger/log_frame.h>
#include <infra/libs/logger/logger.h>
#include <infra/libs/updatable_proto_config/holder.h>
#include <infra/libs/yp_replica/yp_replica.h>

#include <infra/libs/background_thread/background_thread.h>

#include <yp/cpp/yp/client.h>

namespace NYpDns::NDynamicZones {

////////////////////////////////////////////////////////////////////////////////

struct TZoneObjectCreateOptions {
    TVector<NYP::NClient::NApi::NProto::TAccessControlEntry> Acl;

    TZoneObjectCreateOptions(const TZoneObjectCreateConfig& config);
};

struct TZoneManagerOptions {
    TString YpAddress;
    TString YpClientToken;
    TString YpReplicaToken;

    NUpdatableProtoConfig::TConfigHolderPtr<TDnsZonesReplicasConfig> ReplicasConfigHolder;

    TVector<TZone> StaticZones;

    TZoneObjectCreateOptions ZoneObjectCreateOptions;

    NInfra::TLoggerConfig ZonesStatesUpdateLoggerConfig;

    TZoneManagerOptions(const TZonesManagerConfig& config);
};

////////////////////////////////////////////////////////////////////////////////

class TZonesManager {
public:
    TZonesManager(
        TZoneManagerOptions options,
        IZonesStateCoordinatorPtr stateCoordinator
    );

    void Start(NInfra::TLogFramePtr logFrame);

    void CreateZone(const TZone& zone, NInfra::TLogFramePtr logFrame);
    void UpdateZone(const TZone& zone, NInfra::TLogFramePtr logFrame);
    void RemoveZone(const TZoneId& zoneId, NInfra::TLogFramePtr logFrame);

    TVector<TZone> ListZonesForService(
        const TServiceType& serviceType,
        NInfra::TLogFramePtr logFrame
    ) const;

    void ReopenLogs();

private:
    void StartUpdateZonesStates();

    void UpdateZonesStates(NInfra::TLogFramePtr logFrame);

    void UpdateZoneData(
        const TZone& zone,
        const TDnsZoneYpObject& dnsZoneYpObject,
        TZoneStateEntry state,
        NInfra::TLogFramePtr logFrame
    );

    void UpdateZoneState(
        const TZoneId& zoneId,
        const TDnsZoneYpObject& dnsZoneYpObject,
        const TZoneStateEntry& state,
        NInfra::TLogFramePtr logFrame
    );

    void UpdateZoneCurrentState(
        const TZoneId& zoneId,
        const TDnsZoneYpObject& dnsZoneYpObject,
        const TString& currentState,
        NInfra::TLogFramePtr logFrame
    );

    TVector<TDnsZoneYpObject> ListAllZones(NInfra::TLogFramePtr logFrame) const;

    TDnsZoneYpObject GetDnsZoneYpObject(
        const TZoneId& zoneId,
        NInfra::TLogFramePtr logFrame
    ) const;

private:
    void SetZoneObjectAcl(NYP::NClient::TDnsZone& zone) const;

private:
    const TZoneManagerOptions Options_;

    NInfra::TLogger ZonesStatesUpdateLogger_;
    NInfra::TLogger ReplicasLogger_;

    const NYP::NClient::TClientPtr YpClient_;
    TDnsZonesReplicaPtr DnsZonesReplica_;
    IZonesStateCoordinatorPtr StateCoordinator_;

    THolder<NInfra::IBackgroundThread> ZonesStatesUpdater_;
};

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns::NDynamicZones
