#pragma once

#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/api/api.pb.h>

#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/service_iface/api.h>

#include <infra/libs/yp_dns/zone/zone.h>

#include <util/datetime/base.h>

namespace NYpDns::NDynamicZones {

////////////////////////////////////////////////////////////////////////////////

struct TZonesManagerServiceClientOptions {
    TString Address;
    TDuration Timeout = TDuration::Seconds(10);

    TZonesManagerServiceClientOptions& SetAddress(TString value) {
        Address = std::move(value);
        return *this;
    }

    TZonesManagerServiceClientOptions& SetTimeout(TDuration value) {
        Timeout = std::move(value);
        return *this;
    }
};

////////////////////////////////////////////////////////////////////////////////

class TRawZonesManagerServiceClient : public IZonesManagerApi {
public:
    TRawZonesManagerServiceClient(TZonesManagerServiceClientOptions options);
    ~TRawZonesManagerServiceClient();

    void ListZones(NInfra::TRequestPtr<NApi::TReqListZones> request, NInfra::TReplyPtr<NApi::TRspListZones> reply) override;

    void CreateZone(NInfra::TRequestPtr<NApi::TReqCreateZone> request, NInfra::TReplyPtr<NApi::TRspCreateZone> reply) override;

    void RemoveZone(NInfra::TRequestPtr<NApi::TReqRemoveZone> request, NInfra::TReplyPtr<NApi::TRspRemoveZone> reply) override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

////////////////////////////////////////////////////////////////////////////////

class TZonesManagerServiceClient {
public:
    TZonesManagerServiceClient(TZonesManagerServiceClientOptions options);
    ~TZonesManagerServiceClient();

    NApi::TRspListZones ListZones(TString serviceType) const;

    NApi::TRspCreateZone CreateZone(TZoneConfig zoneConfig) const;

    NApi::TRspRemoveZone RemoveZone(TZoneId zoneId) const;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns::NDynamicZones
