#include "make_events.h"

#include <infra/libs/yp_dns/zone/eventlog/events/events_decl.ev.pb.h>
#include <infra/libs/yp_dns/zone/eventlog/make_events.h>

#include <infra/libs/service_iface/eventlog/make_events.h>

namespace NYpDns::NDynamicZones {

////////////////////////////////////////////////////////////////////////////////

NYpDns::NEventlog::TZone MakeZoneEvent(const NApi::TZone& zone) {
    NYpDns::NEventlog::TZone event;
    event.SetId(zone.config().GetName());
    *event.MutableConfig() = MakeZoneConfigEvent(zone.config());
    return event;
}

////////////////////////////////////////////////////////////////////////////////

NEventlog::TListZonesRequest MakeListZonesRequestEvent(const NApi::TReqListZones& request, const NInfra::TAttributes& attributes) {
    NEventlog::TListZonesRequest event;
    *event.MutableAttributes() = NInfra::MakeAttributesEvent(attributes);
    event.SetServiceType(request.service_type());
    return event;
}

NEventlog::TListZoneResponse MakeListZoneResponseEvent(const NApi::TZone& zone) {
    NEventlog::TListZoneResponse event;
    *event.MutableZone() = MakeZoneEvent(zone);
    return event;
}

NEventlog::TListZonesResponse MakeListZonesResponseEvent(const NApi::TRspListZones& response) {
    NEventlog::TListZonesResponse event;
    event.SetStatus(NApi::TRspListZones::EStatus_Name(response.status()));
    event.SetZonesNumber(response.zones().size());
    return event;
}

////////////////////////////////////////////////////////////////////////////////

NEventlog::TCreateZoneRequest MakeCreateZoneRequestEvent(const NApi::TReqCreateZone& request, const NInfra::TAttributes& attributes) {
    NEventlog::TCreateZoneRequest event;
    *event.MutableAttributes() = NInfra::MakeAttributesEvent(attributes);
    *event.MutableZone() = MakeZoneEvent(request.zone());
    return event;
}

NEventlog::TCreateZoneResponse MakeCreateZoneResponseEvent(const NApi::TRspCreateZone& response) {
    NEventlog::TCreateZoneResponse event;
    event.SetStatus(NApi::TRspCreateZone::EStatus_Name(response.status()));
    event.SetMessage(response.message());
    return event;
}

NEventlog::TConfigAfterFillingMissingFieldsWithDefaults MakeConfigAfterFillingMissingFieldsWithDefaultsEvent(const TZoneConfig& zoneConfig) {
    NEventlog::TConfigAfterFillingMissingFieldsWithDefaults event;
    *event.MutableZoneConfig() = MakeZoneConfigEvent(zoneConfig);
    return event;
}

////////////////////////////////////////////////////////////////////////////////

NEventlog::TRemoveZoneRequest MakeRemoveZoneRequestEvent(const NApi::TReqRemoveZone& request, const NInfra::TAttributes& attributes) {
    NEventlog::TRemoveZoneRequest event;
    *event.MutableAttributes() = NInfra::MakeAttributesEvent(attributes);
    event.SetZoneId(request.zone_id());
    return event;
}

NEventlog::TRemoveZoneResponse MakeRemoveZoneResponseEvent(const NApi::TRspRemoveZone& response) {
    NEventlog::TRemoveZoneResponse event;
    event.SetStatus(NApi::TRspRemoveZone::EStatus_Name(response.status()));
    event.SetMessage(response.message());
    return event;
}

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns::NDynamicZones
