#pragma once

#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/api/api.pb.h>

#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/eventlog/events/events_decl.ev.pb.h>

#include <infra/libs/service_iface/request.h>

namespace NYpDns::NDynamicZones {

////////////////////////////////////////////////////////////////////////////////

NEventlog::TListZonesRequest MakeListZonesRequestEvent(const NApi::TReqListZones& request, const NInfra::TAttributes& attributes);

NEventlog::TListZoneResponse MakeListZoneResponseEvent(const NApi::TZone& zone);

NEventlog::TListZonesResponse MakeListZonesResponseEvent(const NApi::TRspListZones& response);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TCreateZoneRequest MakeCreateZoneRequestEvent(const NApi::TReqCreateZone& request, const NInfra::TAttributes& attributes);

NEventlog::TCreateZoneResponse MakeCreateZoneResponseEvent(const NApi::TRspCreateZone& response);

NEventlog::TConfigAfterFillingMissingFieldsWithDefaults MakeConfigAfterFillingMissingFieldsWithDefaultsEvent(const TZoneConfig& zoneConfig);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TRemoveZoneRequest MakeRemoveZoneRequestEvent(const NApi::TReqRemoveZone& request, const NInfra::TAttributes& attributes);

NEventlog::TRemoveZoneResponse MakeRemoveZoneResponseEvent(const NApi::TRspRemoveZone& response);

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns::NDynamicZones
