#pragma once

#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/api/api.pb.h>

#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/service_iface/api.h>

#include <infra/libs/service_iface/router.h>
#include <infra/libs/service_iface/str_iface.h>

#include <type_traits>

namespace NYpDns::NDynamicZones {

template <typename IApi, typename = std::enable_if_t<std::is_base_of_v<IZonesManagerApi, IApi>>>
void AddZonesManagerHandlers(NInfra::TRequestRouter<IApi>& router) {
    router
        .template Add<
            NInfra::TSerializedProtoRequest<NApi::TReqListZones>,
            NInfra::TSerializedProtoReply<NApi::TRspListZones>
        >("/zones/list", "List zones", &IZonesManagerApi::ListZones)
        .template Add<
            NInfra::TJson2ProtoRequest<NApi::TReqListZones>,
            NInfra::TProto2JsonReply<NApi::TRspListZones, false, NProtobufJson::TProto2JsonConfig::EnumName>
        >("/zones/list/json", "List zones (json)", &IZonesManagerApi::ListZones)
        .template Add<
            NInfra::TSerializedProtoRequest<NApi::TReqCreateZone>,
            NInfra::TSerializedProtoReply<NApi::TRspCreateZone>
        >("/zone/create", "Create zone", &IZonesManagerApi::CreateZone)
        .template Add<
            NInfra::TJson2ProtoRequest<NApi::TReqCreateZone>,
            NInfra::TProto2JsonReply<NApi::TRspCreateZone, false, NProtobufJson::TProto2JsonConfig::EnumName>
        >("/zone/create/json", "Create zone (json)", &IZonesManagerApi::CreateZone)
        .template Add<
            NInfra::TSerializedProtoRequest<NApi::TReqRemoveZone>,
            NInfra::TSerializedProtoReply<NApi::TRspRemoveZone>
        >("/zone/remove", "Remove zone", &IZonesManagerApi::RemoveZone)
        .template Add<
            NInfra::TJson2ProtoRequest<NApi::TReqRemoveZone>,
            NInfra::TProto2JsonReply<NApi::TRspRemoveZone, false, NProtobufJson::TProto2JsonConfig::EnumName>
        >("/zone/remove/json", "Remove zone (json)", &IZonesManagerApi::RemoveZone);
}

} // namespace NYpDns::NDynamicZones
