#pragma once

#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/api/api.pb.h>
#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/config/config.pb.h>
#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/service_iface/api.h>

#include <infra/libs/yp_dns/dynamic_zones/zones_manager.h>

#include <infra/libs/logger/logger.h>

namespace NYpDns::NDynamicZones {

////////////////////////////////////////////////////////////////////////////////

struct TZonesManagerServiceOptions {
    TVector<TString> DefaultYpClustersForNewZone;
    TVector<TString> AdditionalOwnersForNewZone;

    TZoneManagerOptions ZonesManagerOptions;
    IZonesStateCoordinatorPtr StateCoordinator;
    NInfra::TLoggerConfig LoggerConfig;

    TZonesManagerServiceOptions(
        const TZonesManagerServiceConfig& zonesManagerServiceConfig,
        IZonesStateCoordinatorPtr stateCoordinator
    );
};

////////////////////////////////////////////////////////////////////////////////

class TZonesManagerService : public IZonesManagerApi {
public:
    TZonesManagerService(TZonesManagerServiceOptions options);

    void Start();

    void ReopenLogs();

    void ListZones(NInfra::TRequestPtr<NApi::TReqListZones> request, NInfra::TReplyPtr<NApi::TRspListZones> reply) override;

    void CreateZone(NInfra::TRequestPtr<NApi::TReqCreateZone> request, NInfra::TReplyPtr<NApi::TRspCreateZone> reply) override;

    void RemoveZone(NInfra::TRequestPtr<NApi::TReqRemoveZone> request, NInfra::TReplyPtr<NApi::TRspRemoveZone> reply) override;

private:
    void ValidateZoneConfig(const TZoneConfig& zoneConfig) const;
    void FillMissingFieldsWithDefaults(TZoneConfig& zoneConfig) const;

private:
    const TZonesManagerServiceOptions Options_;
    NInfra::TLogger Logger_;
    TZonesManager ZonesManager_;
};

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns::NDynamicZones
