#pragma once

#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/api/api.pb.h>

#include <infra/libs/service_iface/reply.h>
#include <infra/libs/service_iface/request.h>

namespace NYpDns::NDynamicZones {

class IZonesManagerApi {
public:
    virtual ~IZonesManagerApi() = default;

    virtual void ListZones(NInfra::TRequestPtr<NApi::TReqListZones>, NInfra::TReplyPtr<NApi::TRspListZones>) = 0;

    virtual void CreateZone(NInfra::TRequestPtr<NApi::TReqCreateZone>, NInfra::TReplyPtr<NApi::TRspCreateZone>) = 0;

    virtual void RemoveZone(NInfra::TRequestPtr<NApi::TReqRemoveZone>, NInfra::TReplyPtr<NApi::TRspRemoveZone>) = 0;
};

} // namespace NYpDns::NDynamicZones
