#include "record_set.h"

namespace NYpDns {

TRecordSet::TRecordSet() = default;

TRecordSet::TRecordSet(NYP::NClient::TDnsRecordSet&& recordSet) {
    Proto_.mutable_meta()->Swap(recordSet.MutableMeta());
    Proto_.mutable_spec()->Swap(recordSet.MutableSpec());
    if (recordSet.Labels().Has("zone") && recordSet.Labels()["zone"].IsString()) {
        Zone_ = recordSet.Labels()["zone"].GetString();
    }
    if (recordSet.Labels().Has("changelist")) {
        Changelist_.ConstructInPlace(recordSet.Labels()["changelist"]);
    }
    if (recordSet.Labels().Has("shard_id") && recordSet.Labels()["shard_id"].IsString()) {
        ShardId_ = recordSet.Labels()["shard_id"].GetString();
    }
}

TRecordSet::TRecordSet(const ui64 ypTimestamp, NYP::NClient::TDnsRecordSet&& recordSet)
    : TRecordSet(std::move(recordSet))
{
    YpTimestamp_ = ypTimestamp;
}

TRecordSet::TRecordSet(const NYP::NClient::TDnsRecordSet& recordSet) {
    *Proto_.mutable_meta() = recordSet.Meta();
    *Proto_.mutable_spec() = recordSet.Spec();
    if (recordSet.Labels().Has("zone") && recordSet.Labels()["zone"].IsString()) {
        Zone_ = recordSet.Labels()["zone"].GetString();
    }
    if (recordSet.Labels().Has("changelist")) {
        Changelist_.ConstructInPlace(recordSet.Labels()["changelist"]);
    }
    if (recordSet.Labels().Has("shard_id")) {
        ShardId_ = recordSet.Labels()["shard_id"].GetString();
    }
}

TRecordSet::TRecordSet(const ui64 ypTimestamp, const NYP::NClient::TDnsRecordSet& recordSet)
    : TRecordSet(recordSet)
{
    YpTimestamp_ = ypTimestamp;
}

NYP::NClient::TDnsRecordSet TRecordSet::MakeYpObject() const {
    NYP::NClient::TDnsRecordSet result;
    *result.MutableMeta() = Proto_.meta();
    *result.MutableSpec() = Proto_.spec();
    if (Zone_.Defined()) {
        (*result.MutableLabels())["zone"] = *Zone_;
    }
    if (Changelist_.Defined()) {
        (*result.MutableLabels())["changelist"] = Changelist_->ToJson();
    }
    if (ShardId_.Defined()) {
        (*result.MutableLabels())["shard_id"] = *ShardId_;
    }
    return result;
}

} // namespace NYpDns
