#pragma once

#include <infra/libs/yp_dns/changelist/changelist.h>
#include <infra/libs/yp_dns/record_set/record_set.h>

#include <yp/cpp/yp/data_model.h>

namespace NYpDns {

using TRecordChangeCallback = std::function<void(const NYP::NClient::NApi::NProto::TDnsRecordSetSpec::TResourceRecord&)>;
using TNoArgCallback = std::function<void()>;

////////////////////////////////////////////////////////////////////////////////

bool AddChangelistEntry(TMaybe<TRecordSet>& recordSet, TChange change, bool incrementVersion = false);

////////////////////////////////////////////////////////////////////////////////

bool ApplyUpdateRequest(TMaybe<TRecordSet>& recordSet, const TChange& change, bool writeToChangelist, const TRecordChangeCallback& beforeUpdateCallback, const TRecordChangeCallback& afterUpdateCallback, const TNoArgCallback& notFoundCallback);

bool ApplyUpdateRequest(TMaybe<TRecordSet>& recordSet, const TChange& change, bool writeToChangelist);

////////////////////////////////////////////////////////////////////////////////

bool ApplyRemoveRequest(TMaybe<TRecordSet>& recordSet, const TChange& change, bool writeToChangelist, const TRecordChangeCallback& removeRecordCallback);

bool ApplyRemoveRequest(TMaybe<TRecordSet>& recordSet, const TChange& change, bool writeToChangelist);

////////////////////////////////////////////////////////////////////////////////

bool ApplyRequest(TMaybe<TRecordSet>& recordSet, const TChange& change, bool writeToChangelist);

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns
