#include "iterate.h"

namespace NYpDns {

void Iterate(const THashMap<TString, TVector<TSerializedRecordSet>>& recordSets, const std::function<bool(const TRecordSetReplicas&)>& callback) {
    THashMap<TString, TVector<TSerializedRecordSet>::const_iterator> its;
    for (const auto& [cluster, recordSets] : recordSets) {
        its[cluster] = recordSets.cbegin();
    }

    while (!recordSets.empty()) {
        TMaybe<TVector<TSerializedRecordSet>::const_iterator> lowestIt;
        for (auto& [cluster, it] : its) {
            const TVector<TSerializedRecordSet>& clusterRecordSets = recordSets.at(cluster);
            if (it != clusterRecordSets.cend()) {
                if (!lowestIt || (*lowestIt)->GetObject().Meta().id() > it->GetObject().Meta().id()) {
                    lowestIt = it;
                }
            }
        }

        if (!lowestIt) {
            break;
        }

        TRecordSetReplicas replicas;
        replicas.Fqdn = (*lowestIt)->GetObject().Meta().id();;
        replicas.Replicas.reserve(its.size());
        for (auto& [cluster, it] : its) {
            const TVector<TSerializedRecordSet>& clusterRecordSets = recordSets.at(cluster);
            if (it != clusterRecordSets.cend() && it->GetObject().Meta().id() == replicas.Fqdn) {
                replicas.Replicas.emplace_back(TRecordSetReplica{cluster, MakeMaybe(it->GetObject())});
                ++it;
            } else {
                replicas.Replicas.emplace_back(TRecordSetReplica{cluster, Nothing()});
            }
        }

        if (!callback(replicas)) {
            break;
        }
    }
}

} // namespace NYpDns
