#pragma once

#include <infra/libs/yp_dns/record_set/record_set.h>
#include <infra/libs/yp_dns/changelist/changelist.h>
#include <infra/libs/yp_dns/changelist/proto/merge_config.pb.h>

#include <infra/libs/yp_dns/record_set/record_set.h>

#include <yp/cpp/yp/data_model.h>

namespace NYpDns {

struct TClassifiedChanges {
    TVector<TChange> ToBeApplied;
    TVector<TChange> ToSetReplicated;
    TVector<TChange> ToBeRemoved;
};

struct TMergeOptions {
    TMergeOptions() = default;
    TMergeOptions(const TMergeConfig& config);

    bool FormChangelist = true;

    TMergeOptions& SetFormChangelist(bool value) {
        FormChangelist = value;
        return *this;
    }

    bool MergeAcls = true;

    TMergeOptions& SetMergeAcls(bool value) {
        MergeAcls = value;
        return *this;
    }
};

TMaybe<TRecordSet> MergeInOne(const THashMap<TString, TMaybe<TRecordSet>>& recordSets, const TMergeOptions& options);
TMaybe<TRecordSet> MergeInOne(TVector<TRecordSetReplica> recordSets, const TMergeOptions& options);

THashMap<TString, TMaybe<TRecordSet>> ReplicateChanges(const THashMap<TString, TMaybe<TRecordSet>>& recordSets);

} // namespace NYpDns
