#include "token.h"

#include <yp/cpp/yp/token.h>

#include <util/system/env.h>

namespace NYpDns {

////////////////////////////////////////////////////////////////////////////////

const TString YP_TOKEN_ENV_KEY = "YP_TOKEN";
const TString YP_CLIENT_TOKEN_ENV_KEY = "YP_TOKEN_CLIENT";
const TString YP_REPLICA_TOKEN_ENV_KEY = "YP_TOKEN_REPLICA";

////////////////////////////////////////////////////////////////////////////////

TString FindToken(const TString& envKey, const TString& defaultToken) {
    return GetEnv(envKey, defaultToken);
}

////////////////////////////////////////////////////////////////////////////////

TString FindYpClientToken(EDefaultToken policyDefault) {
    switch (policyDefault) {
        case EDefaultToken::NONE:
            return FindToken(YP_CLIENT_TOKEN_ENV_KEY);
        case EDefaultToken::YP_TOKEN:
            return FindToken(YP_CLIENT_TOKEN_ENV_KEY, NYP::NClient::FindToken());
    }
}

TString FindYpReplicaToken(EDefaultToken policyDefault) {
    switch (policyDefault) {
        case EDefaultToken::NONE:
            return FindToken(YP_REPLICA_TOKEN_ENV_KEY);
        case EDefaultToken::YP_TOKEN:
            return FindToken(YP_REPLICA_TOKEN_ENV_KEY, NYP::NClient::FindToken());
    }
}

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns
