#pragma once

#include <util/generic/string.h>

namespace NYpDns {

////////////////////////////////////////////////////////////////////////////////

extern const TString YP_TOKEN_ENV_KEY;
extern const TString YP_CLIENT_TOKEN_ENV_KEY;
extern const TString YP_REPLICA_TOKEN_ENV_KEY;

////////////////////////////////////////////////////////////////////////////////

enum class EDefaultToken {
    NONE,
    YP_TOKEN,
};

////////////////////////////////////////////////////////////////////////////////

TString FindToken(const TString& envKey, const TString& defaultToken = {});

////////////////////////////////////////////////////////////////////////////////

TString FindYpClientToken(EDefaultToken policyDefault = EDefaultToken::YP_TOKEN);

TString FindYpReplicaToken(EDefaultToken policyDefault = EDefaultToken::YP_TOKEN);

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns
