#include "make_events.h"

namespace NYpDns {

////////////////////////////////////////////////////////////////////////////////

NEventlog::TZoneConfig MakeZoneConfigEvent(const TZoneConfig& zoneConfig) {
    NEventlog::TZoneConfig event;
    event.SetName(zoneConfig.GetName());
    if (zoneConfig.HasPrimaryNameserver()) {
        event.SetPrimaryNameserver(zoneConfig.GetPrimaryNameserver());
    }
    if (!zoneConfig.GetNameservers().empty()) {
        event.MutableNameservers()->Reserve(zoneConfig.GetNameservers().size());
        for (const TString& nameserver : zoneConfig.GetNameservers()) {
            event.AddNameservers(nameserver);
        }
    }
    if (!zoneConfig.GetYPClusters().empty()) {
        event.MutableYpClusters()->Reserve(zoneConfig.GetYPClusters().size());
        for (const TString& nameserver : zoneConfig.GetYPClusters()) {
            event.AddYpClusters(nameserver);
        }
    }
    if (zoneConfig.HasSelectRecordSetMode()) {
        event.SetSelectRecordSetMode(ESelectRecordSetMode_Name(zoneConfig.GetSelectRecordSetMode()));
    }
    if (zoneConfig.HasDefaultTtl()) {
        event.SetDefaultTtl(zoneConfig.GetDefaultTtl());
    }
    if (zoneConfig.HasNSRecordTtl()) {
        event.SetNSRecordTtl(zoneConfig.GetNSRecordTtl());
    }
    if (zoneConfig.HasSOARecordTtl()) {
        event.SetSOARecordTtl(zoneConfig.GetSOARecordTtl());
    }
    if (zoneConfig.HasSOARecordMinimumTtl()) {
        event.SetSOARecordMinimumTtl(zoneConfig.GetSOARecordMinimumTtl());
    }
    if (zoneConfig.HasSOARefresh()) {
        event.SetSOARefresh(zoneConfig.GetSOARefresh());
    }
    if (zoneConfig.HasSOARetry()) {
        event.SetSOARetry(zoneConfig.GetSOARetry());
    }
    if (zoneConfig.HasSupportSRV()) {
        event.SetSupportSRV(zoneConfig.GetSupportSRV());
    }
    if (zoneConfig.HasSupportPTR()) {
        event.SetSupportPTR(zoneConfig.GetSupportPTR());
    }
    if (zoneConfig.HasDefaultTtl()) {
        event.SetDefaultTtl(zoneConfig.GetDefaultTtl());
    }
    return event;
}

NEventlog::TZone MakeZoneEvent(const TZone& zone) {
    NEventlog::TZone event;
    event.SetId(zone.GetId());
    *event.MutableConfig() = MakeZoneConfigEvent(zone.Config());
    return event;
}

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns
