#include "response_policy.h"

namespace NYpDns {

namespace {

TTypeResponsePolicy GetSOATypeDefaultResponsePolicy() {
    TTypeResponsePolicy result;
    result.SetOrder(TTypeResponsePolicy::SEQUENTIAL);
    result.SetMaxRecordsNumber(1);
    return result;
}

} // anonymous namespace

const TTypeResponsePolicy* FindTypeResponsePolicy(const TZoneConfig& zoneConfig, ERecordType recordType) {
    #define CASE_TYPE(Type) \
        case ERecordType::Type:                                  \
            return &zoneConfig.GetResponsePolicy().Get##Type();

    #define CASE_TYPE_WITH_DEFAULT(Type, GetDefault) \
        case ERecordType::Type:                                                 \
            if (!zoneConfig.GetResponsePolicy().Has##Type()) {                  \
                static const TTypeResponsePolicy defaultPolicy = GetDefault();  \
                return &defaultPolicy;                                          \
            }                                                                   \
            return &zoneConfig.GetResponsePolicy().Get##Type();

    switch (recordType) {
        CASE_TYPE(A);
        CASE_TYPE(NS);
        CASE_TYPE(CNAME);
        CASE_TYPE_WITH_DEFAULT(SOA, GetSOATypeDefaultResponsePolicy);
        CASE_TYPE(PTR);
        CASE_TYPE(TXT);
        CASE_TYPE(AAAA);
        CASE_TYPE(SRV);
        default:
            return nullptr;
    }

    #undef CASE_TYPE
    #undef CASE_TYPE_WITH_DEFAULT
}

} // namespace NYpDns
