#pragma once

#include <infra/libs/yp_dns/dns_names/view.h>
#include <infra/libs/yp_dns/zone/protos/config.pb.h>

#include <yp/cpp/yp/data_model.h>

#include <library/cpp/protobuf/yt/parse_config.h>
#include <library/cpp/yson/node/node.h>

namespace NYpDns {

using TZoneId = TString;

class TZone {
    static TParseConfig YSON_PARSE_CONFIG;

public:
    TZone(TZoneConfig config);
    TZone(const NYT::TNode& config);
    TZone(const NYP::NClient::TDnsZone& ypObject);

    const TZoneId& GetId() const;
    const TString& GetName() const;
    const TDnsNameView& GetDnsName() const;
    const TZoneConfig& Config() const;

    TZoneConfig* MutableConfig();

    NYT::TNode ConfigToYtNode() const;
    NYP::NClient::TDnsZone ConfigToYpDnsZoneObject() const;

private:
    TZoneConfig Config_;
    TDnsNameView Name_;
};

} // namespace NYpDns
