#pragma once

#include <infra/libs/yp_dns/record_set/record_set.h>
#include <infra/libs/yp_dns/zone/zone.h>

#include <infra/libs/yp_replica/yp_replica.h>

#include <util/generic/hash.h>
#include <util/thread/pool.h>

namespace NYpDns {

////////////////////////////////////////////////////////////////////////////////

using TYpReplicaRecordSetObject = NYP::NYPReplica::TDnsRecordSetReplicaObject;

using TYpReplica = NYP::NYPReplica::TYPReplica<TYpReplicaRecordSetObject>;

using TYpReplicaStorageElement = NYP::NYPReplica::TStorageElement<TYpReplicaRecordSetObject>;

using TYpReplicaListOptions = TYpReplica::TListOptions<TYpReplicaRecordSetObject>;

using TReplicasList = TVector<std::pair<TString, const TYpReplica*>>;

struct TFromReplicaListOptions : public TYpReplicaListOptions {
};

////////////////////////////////////////////////////////////////////////////////

struct TListRecordSetsFromReplicaResult {
    ui64 YpTimestamp = 0;
    TVector<TSerializedRecordSet> RecordSets;
    TFromReplicaListOptions ContinuationOptions;
    bool HasReachedEnd = false;
};

TListRecordSetsFromReplicaResult ListRecordSetsFromReplica(
    const TYpReplica& replica,
    TFromReplicaListOptions listOptions
);

////////////////////////////////////////////////////////////////////////////////

struct TListRecordSetsFromReplicasResult {
    THashMap<TString, ui64> YpTimestamps;
    TVector<TRecordSet> RecordSets;
    THashMap<TString, TFromReplicaListOptions> ClustersContinuationOptions;
    bool HasReachedEnd = false;
};

TListRecordSetsFromReplicasResult ListRecordSetsFromReplicas(
    const TReplicasList& replicas,
    THashMap<TString, TFromReplicaListOptions> clustersListOptions,
    IThreadPool& threadPool,
    const ui64 limit = 0 /* 0 = all */
);

////////////////////////////////////////////////////////////////////////////////

enum class ESeekType {
    ToFirst  /* "ToFirst" */,
    ToLast   /* "ToLast" */,
    AtOrNext /* "AtOrNext" */,
    Next     /* "Next" */,
};

struct TListMulticlusterZoneOptions {
    ESeekType SeekType = ESeekType::ToFirst;
    TString SeekKey;
    ui64 Limit = 0;

    bool BuildSOARecordFromConfigIfNotFound = false;
    bool BuildNSRecordsFromConfigIfNotFound = false;
};

struct TListRecordSetsResult {
    THashMap<TString, ui64> YpTimestamps;
    TVector<TRecordSet> RecordSets;
    TListMulticlusterZoneOptions ContinuationOptions;
};

TListRecordSetsResult ListMulticlusterZone(
    const TZone& zone,
    const TReplicasList& replicas,
    TListMulticlusterZoneOptions listOptions,
    IThreadPool& threadPool,
    NInfra::TLogFramePtr logFrame,
    const NInfra::TSensorGroup& sensorGroup
);

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns
