#pragma once

#include "writer.h"

#include <infra/libs/yp_dns/record_set/record.h>

#include <infra/contrib/pdns/power_dns/dnsname.hh>

#include <util/folder/path.h>
#include <util/generic/maybe.h>
#include <util/stream/file.h>

namespace NYpDns {

struct TEndOfFileException : yexception {
};

struct TIncorrectDirectiveException : yexception {
};

struct TDirectiveNotSupportedException : yexception {
};

class IZoneReader {
public:
    virtual ~IZoneReader() = default;

    virtual bool ReadRecord(TRecord& record) = 0;
};

// TODO(YP-3441): сделать описание класса
class TZoneReader : public IZoneReader {
public:
    TZoneReader(IInputStream& input)
        : Input_(input)
    {
    }

    bool ReadRecord(TRecord& record) override;

    static bool ParseDirective(TStringBuf line, EDirectiveType& type, TString& value);

private:

    void SetDirective(EDirectiveType type, const TString& value);

    TString ReadNextLineWithRecord();

private:
    IInputStream& Input_;
    TMaybe<TString> ZoneOrigin_;
    ui64 ZoneTtl_ = 0;
    TMaybe<DNSName> NamePrevRecord_;
};

class TZoneFileReader : public IZoneReader {
public:
    TZoneFileReader(const TFsPath& zoneFilePath)
        : FileInput_(zoneFilePath)
        , ZoneReader_(FileInput_)
    {
    }

    bool ReadRecord(TRecord& record) override {
        return ZoneReader_.ReadRecord(record);
    }

private:
    TFileInput FileInput_;
    TZoneReader ZoneReader_;
};

} // namespace NYpDns
