#pragma once

#include "storage.h"

#include <infra/libs/yp_replica/protos/backup/backup.pb.h>
#include <infra/libs/yp_replica/protos/config/config.pb.h>

#include <util/folder/path.h>

namespace rocksdb {
    struct BackupInfo;
}

namespace NYP::NYPReplica {
    struct TBackupEngineOptions {
        TBackupEngineOptions() = default;
        TBackupEngineOptions(const TStringBuf name, const TBackupConfig& config);

        TFsPath Path;
        bool BackupLogFiles = false;
    };

    struct TCreateBackupOptions {
        TBackupMeta Meta;
        bool FlushBeforeBackup = true;
    };

    struct TBackupInfo {
        TBackupInfo(const rocksdb::BackupInfo& info);

        ui32 Id = 0;
        ui64 Timestamp = 0;
        ui64 Size = 0;
        ui32 NumberFiles = 0;
        bool IsCorrupted = false;
        TBackupMeta Meta;
    };

    class TBackupEngine {
    public:
        TBackupEngine(TBackupEngineOptions options);
        ~TBackupEngine();

        bool IsOpened() const;

        TStatus Open();

        TStatus Reopen();

        void Drop();

        TStatus CreateNewBackup(const TCreateBackupOptions& options, TStorage* storage);

        TStatus DeleteBackup(ui64 backupId);

        TStatus PurgeOldBackups(ui32 backupsToKeep);

        void StopBackup();

        TVector<TBackupInfo> ListBackups();

    private:
        class TImpl;
        THolder<TImpl> Impl_;
    };
} // namespace NYP::NYPReplica
