#include "event_listener.h"

#include <contrib/libs/rocksdb/include/rocksdb/status.h>
#include <contrib/libs/rocksdb/include/rocksdb/listener.h>

#include <util/generic/utility.h>

namespace NYP::NYPReplica {

class TSpaceLimitEventListener : public rocksdb::EventListener {
public:
    void OnBackgroundError(rocksdb::BackgroundErrorReason reason, rocksdb::Status* bg_error) override {
        if (reason == rocksdb::BackgroundErrorReason::kWriteCallback &&
            bg_error != nullptr &&
            bg_error->code() == rocksdb::Status::Code::kIOError &&
            bg_error->subcode() == rocksdb::Status::SubCode::kSpaceLimit) {
            *bg_error = rocksdb::Status(*bg_error, Min(bg_error->severity(), rocksdb::Status::Severity::kHardError));
        }
    }

    void OnErrorRecoveryBegin(rocksdb::BackgroundErrorReason /* reason */, rocksdb::Status bg_error, bool* auto_recovery) override {
        if (bg_error.code() == rocksdb::Status::Code::kIOError &&
            bg_error.subcode() == rocksdb::Status::SubCode::kSpaceLimit &&
            auto_recovery != nullptr) {
            *auto_recovery = false;
        }
    }
};

std::shared_ptr<rocksdb::EventListener> CreateSpaceLimitEventListener() {
    return std::make_shared<TSpaceLimitEventListener>();
}

} // namespace NYP::NYPReplica
