#include "make_log_events.h"

namespace NYP::NYPReplica {

TReplicaUpdateColumnFamilies MakeReplicaUpdateColumnFamiliesEvent(const TVector<TString>& columnFamilies, TReplicaUpdateColumnFamilies_EAction action) {
    TReplicaUpdateColumnFamilies event;
    event.SetAction(action);
    event.SetSize(columnFamilies.size());
    event.MutableColumnFamilies()->Reserve(columnFamilies.size());
    for (const TString& columnFamily : columnFamilies) {
        event.AddColumnFamilies(columnFamily);
    }
    return event;
}

} // namespace NYP::NYPReplica
