#include "replica_objects.h"

namespace NYP::NYPReplica {

const TVector<TString> TEndpointSetReplicaObject::ATTRIBUTE_SELECTORS = {
    "/meta",
    "/spec",
    "/labels",
    "/status",
};

const TVector<TString> TEndpointReplicaObject::ATTRIBUTE_SELECTORS = {
    "/meta",
    "/spec",
    "/labels",
    "/status",
};

const TVector<TString> TPodReplicaObject::ATTRIBUTE_SELECTORS = {
    "/meta/id",
    "/meta/pod_set_id",
    "/spec/node_id",
    "/status/ip6_address_allocations",
    "/status/ip6_subnet_allocations",
    "/status/dns",
    "/status/iss_conf_summaries",
    "/status/agent/iss_summary",
    "/status/agent/pod_agent_payload/status/boxes",
    "/labels/shard_id",
};

const TVector<TString> TPodWithNodeIdKeyReplicaObject::ATTRIBUTE_SELECTORS = {
    "/meta/id",
    "/meta/pod_set_id",
    "/spec/node_id",
    "/status/dns/persistent_fqdn",
};

const TVector<TString> TDnsRecordSetReplicaObject::ATTRIBUTE_SELECTORS = {
    "/meta/id",
    "/spec",
    "/labels/zone",
    "/labels/changelist",
};

const TVector<TString> TDnsZoneReplicaObject::ATTRIBUTE_SELECTORS = {
    "/meta/id",
    "/spec",
    "/status",
    "/labels",
};

const TVector<TString> TEndpointSetReplicaObject::WATCH_SELECTORS = {
};

const TVector<TString> TEndpointReplicaObject::WATCH_SELECTORS = {
};

const TVector<TString> TPodReplicaObject::WATCH_SELECTORS = {
    "/spec/node_id",
    "/status/ip6_address_allocations",
    "/status/ip6_subnet_allocations",
    "/status/dns",
    "/status/iss_conf_summaries",
    "/status/agent/iss_summary",
    "/labels/shard_id",
};

const TVector<TString> TPodWithNodeIdKeyReplicaObject::WATCH_SELECTORS = {
    "/spec/node_id",
    "/status/dns/persistent_fqdn",
};

const TVector<TString> TDnsRecordSetReplicaObject::WATCH_SELECTORS = {
};

const TVector<TString> TDnsZoneReplicaObject::WATCH_SELECTORS = {
};

} // namespace NYP::NYPReplica
