#pragma once

#include <infra/libs/sensors/sensor.h>

#include <util/generic/strbuf.h>

namespace rocksdb {
    class Statistics;
}

namespace NYP::NYPReplica::NSensors {
    constexpr TStringBuf NAMESPACE = "yp_replica";

    constexpr TStringBuf COLUMN_FAMILY = "column_family";
    constexpr TStringBuf REPLICA_OBJECT_TYPE = "replica_object_type";

    constexpr TStringBuf MASTER_REQUESTS = "master.requests";
    constexpr TStringBuf MASTER_FAILURES = "master.failures";

    constexpr TStringBuf MASTER_SELECT_ALL_CHUNK_REQUEST = "master.select_all.chunk_request";
    constexpr TStringBuf MASTER_SELECT_ALL_CHUNK_SUCCESS = "master.select_all.chunk_success";
    constexpr TStringBuf MASTER_SELECT_ALL_CHUNK_ERROR = "master.select_all.success";
    constexpr TStringBuf MASTER_SELECT_ALL_CHUNK_FAILURE = "master.select_all.failure";
    constexpr TStringBuf MASTER_SELECT_ALL_REQUEST = "master.select_all.request";
    constexpr TStringBuf MASTER_SELECT_ALL_SUCCESS = "master.select_all.success";
    constexpr TStringBuf MASTER_SELECT_ALL_FAILURE = "master.select_all.failure";

    constexpr TStringBuf MASTER_WATCH_CHUNK_REQUEST = "master.watch.chunk_request";
    constexpr TStringBuf MASTER_WATCH_CHUNK_SUCCESS = "master.watch.chunk_success";
    constexpr TStringBuf MASTER_WATCH_CHUNK_ERROR = "master.watch.chunk_error";
    constexpr TStringBuf MASTER_WATCH_CHUNK_FAILURE = "master.watch.chunk_failure";
    constexpr TStringBuf MASTER_WATCH_REQUEST = "master.watch.request";
    constexpr TStringBuf MASTER_WATCH_SUCCESS = "master.watch.success";
    constexpr TStringBuf MASTER_WATCH_FAILURE = "master.watch.failure";
    constexpr TStringBuf MASTER_GET_UPDATED_OBJECTS_CHUNK_REQUEST = "master.watch.get_objects.chunk_request";
    constexpr TStringBuf MASTER_GET_UPDATED_OBJECTS_CHUNK_SUCCESS = "master.watch.get_objects.chunk_success";
    constexpr TStringBuf MASTER_GET_UPDATED_OBJECTS_CHUNK_ERROR = "master.watch.get_objects.chunk_error";
    constexpr TStringBuf MASTER_GET_UPDATED_OBJECTS_CHUNK_FAILURE = "master.watch.get_objects.chunk_failure";
    constexpr TStringBuf MASTER_EVENTS_NUMBER = "master.watch.events_number";
    constexpr TStringBuf MASTER_CREATE_EVENTS_NUMBER = "master.watch.create_events_number";
    constexpr TStringBuf MASTER_UPDATE_EVENTS_NUMBER = "master.watch.update_events_number";
    constexpr TStringBuf MASTER_REMOVE_EVENTS_NUMBER = "master.watch.remove_events_number";

    constexpr TStringBuf BACKUP_AGE = "backup.age";
    constexpr TStringBuf BACKUP_AGE_INDICATOR = "backup.age_indicator";
    constexpr TStringBuf STORAGE_AGE = "storage.age";
    constexpr TStringBuf STORAGE_AGE_INDICATOR = "storage.age_indicator";

    constexpr TStringBuf SELECT_ALL_OBJECTS_RESPONSE_TIME = "select_all_objects_response_time";
    constexpr TStringBuf SELECT_UPDATED_OBJECTS_RESPONSE_TIME = "select_updated_objects_response_time";
    constexpr TStringBuf WATCH_OBJECTS_RESPONSE_TIME = "watch_objects_response_time";
    constexpr TStringBuf SELECT_UPDATES_RESPONSE_TIME = "select_updates_response_time";
    constexpr TStringBuf COPY_UPDATES_TO_STORAGE_RESPONSE_TIME = "copy_updates_to_storage_response_time";
    constexpr TStringBuf REQUEST_UPDATES_RESPONSE_TIME = "request_updates_response_time";
    constexpr TStringBuf CHUNK_SELECTION_RESPONSE_TIME = "chunk_selection_response_time";
    constexpr TStringBuf BACKUP_CREATION_TIME = "backup_creation_time";

    constexpr TStringBuf SELECT_ALL_OBJECTS_RESULT_SIZE = "select_all_objects_result_size";
    constexpr TStringBuf SELECT_ALL_OBJECTS_CHUNK_SIZE = "select_all_objects_chunk_size";
    constexpr TStringBuf YP_CLUSTER = "yp_cluster";

    constexpr TStringBuf MODIFY_ELEMENTS_ERROR = "modify_elements_error";
    constexpr TStringBuf UPDATE_CALLBACK_ERROR = "update_callback_error";
    constexpr TStringBuf TABLE_RULE_CALLBACK_ERROR = "table_rule_callback_error";

    constexpr TStringBuf MAX_OBJECTS_NUMBER = "max_objects_number";
    constexpr TStringBuf SELECTED_OBJECTS_NUMBER = "selected_objects_number";
    constexpr TStringBuf STORAGE_OBJECTS_NUMBER = "storage_objects_number";
    constexpr TStringBuf UPDATES_OBJECTS_NUMBER = "updates_objects_number";
    constexpr TStringBuf MAX_SELECTED_OBJECTS_NUMBER_REACHED = "max_selected_objects_number_reached";

    constexpr TStringBuf SEMAPHORE_COUNTER = "semaphore_counter";
    constexpr TStringBuf SEMAPHORE_ID = "semaphore_id";

    constexpr TStringBuf STORAGE = "storage";
    constexpr TStringBuf SST_FILES_SIZE = "rocksdb.sst_files_size_bytes";
    constexpr TStringBuf STORAGE_SIZE = "rocksdb.size_bytes";
    constexpr TStringBuf MAX_ALLOWED_SPACE_USAGE = "rocksdb.max_allowed_space_usage";
    constexpr TStringBuf COMPACTION_BUFFER_SIZE = "rocksdb.compaction_buffer_size";
    constexpr TStringBuf IS_MAX_ALLOWED_SPACE_REACHED = "rocksdb.is_max_allowed_space_reached";
    constexpr TStringBuf IS_MAX_ALLOWED_SPACE_REACHED_INCLUDING_COMPLACTIONS = "rocksdb.is_max_allowed_space_reached_including_compactions";

    constexpr TStringBuf BACKUP_SIZE = "backup.size_bytes";

    constexpr std::initializer_list<std::tuple<TStringBuf, double, double>> HISTOGRAMS_INIT_PARAMETERS = {
        {COPY_UPDATES_TO_STORAGE_RESPONSE_TIME, 1.5, 10.0},
        {BACKUP_CREATION_TIME, 1.5, 10.0},
        {REQUEST_UPDATES_RESPONSE_TIME, 1.5, 10.0},
    };

    constexpr std::initializer_list<std::tuple<TStringBuf, double, double>> HISTOGRAMS_BY_COLUMN_FAMILY_INIT_PARAMETERS = {
        {CHUNK_SELECTION_RESPONSE_TIME, 1.5, 10.0},
        {SELECT_ALL_OBJECTS_RESPONSE_TIME, 1.5, 10.0},
        {SELECT_ALL_OBJECTS_RESULT_SIZE, 1.5, 10.0},
        {SELECT_ALL_OBJECTS_CHUNK_SIZE, 1.5, 10.0},
        {SELECT_UPDATED_OBJECTS_RESPONSE_TIME, 1.5, 10.0},
        {WATCH_OBJECTS_RESPONSE_TIME, 1.5, 10.0},
        {SELECT_UPDATES_RESPONSE_TIME, 1.5, 10.0},
    };

    constexpr TStringBuf FAILS_IN_A_ROW = "fails_in_a_row";

    class TRocksDBSensorsUpdater {
    public:
        TRocksDBSensorsUpdater(NInfra::TSensorGroup sensorGroup, std::shared_ptr<rocksdb::Statistics> statistics)
            : SensorGroup_(sensorGroup)
            , Statistics_(statistics)
        {
        }

        void UpdateTickerSensors();

        void UpdateHistogramSensors();

    private:
        enum class ESensorType {
            SKIPPED,
            INT_GAUGE,
            GAUGE,
            RATE,
            HISTOGRAM_COUNTER,
            HISTOGRAM_RATE,
            DURATION
        };

        ESensorType SelectorSensor(const TStringBuf sensor, bool isTicker);

    private:
        const NInfra::TSensorGroup SensorGroup_;
        std::shared_ptr<rocksdb::Statistics> Statistics_;
    };
} // namespace NYP::NYPReplica::NSensors
