#pragma once

#include <infra/libs/yp_replica/tools/semaphore_updater/protos/config.pb.h>

#include <yp/cpp/yp/client.h>

#include <util/generic/fwd.h>
#include <util/generic/vector.h>

namespace NYP::NYPReplica::NSemaphoreUpdater {

struct TSemaphore {
    TString SemaphoreId;
    bool NonDefaultOwners = false;
    NClient::TSemaphoreSet YpSemaphoreSet;
    TVector<NClient::TSemaphore> YpSemaphores;
};

TVector<TSemaphore> SelectSemaphores(NClient::TClient& client, const TStringBuf serviceId);

TVector<TSemaphore> GetSemaphoresFromClusterConfig(const TYpClusterConfig& ypClusterConfig, const TStringBuf serviceId, const TVector<TString>& owners = {});

bool CreateSemaphore(NClient::TClient& client, const TSemaphore& semaphore);

bool RemoveSemaphore(NClient::TClient& client, const TSemaphore& semaphore);

bool UpdateSemaphore(NClient::TClient& client, const TSemaphore& oldSemaphore, const TSemaphore& newSemaphore);

} // NYP::NYPReplica::NSemaphoreUpdater
