#include <infra/libs/yp_replica/tools/semaphore_updater/protos/config.pb.h>

#include <infra/libs/yp_replica/tools/semaphore_updater/lib/updater.h>

#include <yp/cpp/yp/token.h>

#include <library/cpp/getopt/small/last_getopt.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/proto_config/load.h>

#include <util/generic/fwd.h>

struct TOptions {
    TFsPath Config;
    TString YpToken;
    ui64 RetryCount;
};

TOptions ParseOptions(int argc, const char* argv[]) {
    TOptions result;

    NLastGetopt::TOpts opts;

    opts.AddHelpOption();

    opts
        .AddLongOption('c', "config", "Path to config")
        .Required()
        .RequiredArgument("PATH")
        .StoreResult(&result.Config);

    opts
        .AddLongOption('t', "yp-token", "YP token")
        .Optional()
        .RequiredArgument()
        .DefaultValue(NYP::NClient::FindToken())
        .StoreResult(&result.YpToken);

    opts
        .AddLongOption('r', "retry-count", "Retry count for updates in one cluster")
        .Optional()
        .RequiredArgument()
        .DefaultValue(3)
        .StoreResult(&result.RetryCount);

    NLastGetopt::TOptsParseResult{&opts, argc, argv};

    return result;
}

int RunMain(const TOptions& options) {
    NProtoConfig::TLoadConfigOptions configOptions;
    configOptions.Path = options.Config;
    const auto cfg = NProtoConfig::LoadWithOptions<NYP::NYPReplica::NSemaphoreUpdater::TConfig>(configOptions);
    return NYP::NYPReplica::NSemaphoreUpdater::UpdateSemaphores(cfg, options.RetryCount, options.YpToken);
}

int main(int argc, const char* argv[]) {
    InitGlobalLog2Console();
    return RunMain(ParseOptions(argc, argv));
}
