#include "update.h"

namespace NYP::NYPReplica {

TUpdatesDisabler::TUpdatesDisabler(bool enableUpdates)
    : EnableUpdates_(enableUpdates)
{
}

void TUpdatesDisabler::EnableUpdates() {
    TGuard<TMutex> guard(SwitchEnableUpdatesMutex_);
    EnableUpdates_.store(true);
}

void TUpdatesDisabler::DisableUpdates() {
    TGuard<TMutex> guard(SwitchEnableUpdatesMutex_);
    EnableUpdates_.store(false);
}

bool TUpdatesDisabler::UpdatesDisabled() const {
    return !EnableUpdates_.load();
}

void TUpdatesDisabler::ThrowIfUpdatesDisabled() const {
    if (UpdatesDisabled()) {
        ythrow TError(TError::UpdatesDisabled);
    }
}

TStatus TUpdatesDisabler::Status() const {
    if (UpdatesDisabled()) {
        return TStatus::UpdatesDisabled();
    }
    return TStatus::Ok();
}

TDisableUpdatesGuard::TDisableUpdatesGuard(TAtomicSharedPtr<TUpdatesDisabler> updatesDisabler)
    : UpdatesDisabler_(std::move(updatesDisabler))
    , SwitchEnableUpdatesGuard_(UpdatesDisabler_->SwitchEnableUpdatesMutex_)
    , InitValue_(UpdatesDisabler_->EnableUpdates_.exchange(false))
{
}

TDisableUpdatesGuard::~TDisableUpdatesGuard() {
    UpdatesDisabler_->EnableUpdates_.store(InitValue_);
}

} // namespace NYP::NYPReplica
