#pragma once

#include "data_model.h"
#include "status.h"

#include <util/system/guard.h>
#include <util/system/mutex.h>

namespace NYP::NYPReplica {

class TUpdatesDisabler {
    friend class TDisableUpdatesGuard;
public:
    TUpdatesDisabler(bool enableUpdates);

    void EnableUpdates();
    void DisableUpdates();

    bool UpdatesDisabled() const;
    void ThrowIfUpdatesDisabled() const;

    TStatus Status() const;

private:
    TMutex SwitchEnableUpdatesMutex_;
    std::atomic<bool> EnableUpdates_ = {true};
};

class TDisableUpdatesGuard {
public:
    TDisableUpdatesGuard(TAtomicSharedPtr<TUpdatesDisabler> updatesDisabler);

    ~TDisableUpdatesGuard();

private:
    TAtomicSharedPtr<TUpdatesDisabler> UpdatesDisabler_;
    const TGuard<TMutex> SwitchEnableUpdatesGuard_;
    const bool InitValue_;
};

template <typename TReplicaObject>
struct TUpdate {
    TUpdate(TMaybe<TReplicaObject>&& oldValue, TStorageElement<TReplicaObject>&& newValue)
        : OldValue(std::move(oldValue))
        , NewValue(std::move(newValue))
    {
    }

    TMaybe<TReplicaObject> OldValue;
    TStorageElement<TReplicaObject> NewValue;
};

template <typename TReplicaObject>
struct TUpdates {
    TVector<TUpdate<TReplicaObject>> Data;
    ui64 SnapshotObjectsNumber;
    ui64 YpTimestamp;
    TInstant Timestamp;
};

} // namespace NYP::NYPReplica
