#include "util.h"

#include <contrib/libs/rocksdb/include/rocksdb/slice.h>

#include <util/folder/iterator.h>

TString ToString(const rocksdb::Slice& slice) {
    return TString{slice.data(), slice.size()};
}

namespace NYP::NYPReplica {

TRetryOptions CreateRetryOptions(const TRetryConfig& config) {
    return TRetryOptions().WithCount(config.GetRetryAttempts())
                          .WithSleep(TDuration::Parse(config.GetMinDelay()))
                          .WithRandomDelta(TDuration::Parse(config.GetMaxRandomDelta()))
                          .WithIncrement(TDuration::Parse(config.GetIncrementDelta()))
                          .WithExponentialMultiplier(TDuration::Parse(config.GetExponentialMultiplier()));
}

ui64 GetTotalDirectorySizeBytes(const TFsPath& dirPath) {
    ui64 totalSizeBytes = 0;
    try {
        TDirIterator dir(dirPath.GetPath());
        for (auto file = dir.begin(); file != dir.end(); ++file) {
            if (file->fts_info == FTS_F || file->fts_info == FTS_SL) {
                totalSizeBytes += TFileStat(file->fts_path, true /* nofollow */).Size;
            }
        }
    } catch (const TDirIterator::TError&) {
        return 0;
    }
    return totalSizeBytes;
}

} // namespace NYP::NYPReplica
