LIBRARY()

OWNER(
    g:yp-controllers-lib
    g:yp-sd
    g:yp-dns
)

SRCS(
    backup.cpp
    cache.cpp
    data_model.cpp
    event_listener.cpp
    make_log_events.cpp
    replica_objects.cpp
    sensors.cpp
    status.cpp
    storage_options.cpp
    storage.cpp
    table.cpp
    util.cpp
    update.cpp
    yp_replica.cpp
)

PEERDIR(
    infra/libs/yp_replica/protos
    infra/libs/yp_replica/protos/backup
    infra/libs/yp_replica/protos/config

    infra/libs/background_thread
    infra/libs/logger
    infra/libs/sensors
    infra/libs/updatable_proto_config
    infra/libs/yp_updates_coordinator/client

    yp/client/api/misc
    yp/cpp/yp

    contrib/libs/rocksdb

    library/cpp/protobuf/interop
    library/cpp/retry
    library/cpp/string_utils/base64
    library/cpp/threading/light_rw_lock
    library/cpp/yson
)

GENERATE_ENUM_SERIALIZATION(
    storage.h
)

GENERATE_ENUM_SERIALIZATION(
    status.h
)

END()
