#pragma once

#include <infra/libs/yp_updates_coordinator/client/protos/config/config.pb.h>

#include <infra/libs/yp_updates_coordinator/instance_state/state/state.h>

#include <infra/libs/logger/log_frame.h>

#include <util/datetime/base.h>
#include <util/generic/ptr.h>
#include <util/system/hostname.h>

namespace NYPUpdatesCoordinator {

struct TClientOptions {
    TString ProviderAddress;
    TDuration ProviderRequestTimeout = TDuration::Seconds(10);

    TString YtProxy;
    TString YtToken;
    TString CypressRootPath;
    TString Service;
    TMaybe<TString> PrimaryMedium;

    TMaybe<TString> InstanceName;
    TString InstanceLocation;
    bool ParticipateInCoordination = false;
    TDuration LockTimeout = TDuration::Seconds(10);
};

TClientOptions MakeClientOptions(const TClientConfig& config);

class TClient {
public:
    TClient(TClientOptions options, NInfra::TLogFramePtr logFrame);

    ~TClient();

    void StartParticipateInCoordination(NInfra::TLogFramePtr logFrame) const;

    ui64 GetTargetState(NInfra::TLogFramePtr logFrame) const;

    void SetCurrentState(TTimestampClientInfo timestampInfo, NInfra::TLogFramePtr logFrame) const;

    void SetTimestampUpdateStatus(const ui64 timestamp, TUpdateStatus status, NInfra::TLogFramePtr logFrame) const;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NYPUpdatesCoordinator
