#include "provider_client.h"

#include "raw_provider_client.h"

#include <infra/libs/yp_updates_coordinator/logger/make_events.h>

#include <infra/libs/service_iface/str_iface.h>

#include <util/generic/guid.h>
#include <util/system/hostname.h>

namespace NYPUpdatesCoordinator::NDetail {

class TProviderClient::TImpl {
public:
    TImpl(TString instanceName, TProviderClientOptions options)
        : InstanceName_(std::move(instanceName))
        , RawClient_(std::move(options))
    {
    }

    NApi::TRspGetTargetState GetTargetState(const TString& service, NInfra::TLogFramePtr logFrame) {
        NApi::TReqGetTargetState request;
        request.set_service(service);
        request.set_instance_name(InstanceName_);

        NInfra::TAttributes attributes = {{
            {"request-id", CreateGuidAsString()},
        }};

        logFrame->LogEvent(MakeProviderClientGetTargetStateRequestEvent(request, attributes));

        NApi::TRspGetTargetState response;
        NInfra::TAttributes responseAttributes;
        RawClient_.GetTargetState(
            NInfra::RequestPtr<NInfra::TProtoRequest<NApi::TReqGetTargetState>>("", std::move(request), std::move(attributes)),
            NInfra::ReplyPtr<NInfra::TProtoReply<NApi::TRspGetTargetState>>(response, responseAttributes)
        );

        logFrame->LogEvent(MakeProviderClientGetTargetStateResponseEvent(response, responseAttributes));

        return response;
    }

private:
    const TString InstanceName_;
    TRawProviderClient RawClient_;
};

TProviderClient::TProviderClient(TString instanceName, TProviderClientOptions options)
    : Impl_(MakeHolder<TImpl>(std::move(instanceName), std::move(options)))
{
}

TProviderClient::~TProviderClient() = default;

NApi::TRspGetTargetState TProviderClient::GetTargetState(const TString& service, NInfra::TLogFramePtr logFrame) {
    return Impl_->GetTargetState(service, logFrame);
}

} // namespace NYPUpdatesCoordinator::NDetail
