#pragma once

#include "provider_client_options.h"

#include <infra/libs/yp_updates_coordinator/api/api.pb.h>

#include <infra/libs/logger/log_frame.h>

#include <util/datetime/base.h>

namespace NYPUpdatesCoordinator::NDetail {

class TProviderClient {
public:
    TProviderClient(TString instanceName, TProviderClientOptions options);

    ~TProviderClient();

    NApi::TRspGetTargetState GetTargetState(const TString& service, NInfra::TLogFramePtr logFrame);

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NYPUpdatesCoordinator::NDetail
