#pragma once

#include "provider_client_options.h"

#include <infra/libs/yp_updates_coordinator/api/api.grpc.pb.h>
#include <infra/libs/yp_updates_coordinator/service_iface/api.h>

namespace NYPUpdatesCoordinator::NDetail {

class TRawProviderClient: public IApi {
public:
    TRawProviderClient(TRawProviderClientOptions options);

    ~TRawProviderClient();

    void Ping(NInfra::TRequestPtr<NApi::TReqPing>, NInfra::TReplyPtr<NApi::TRspPing>) override;

    void GetTargetState(NInfra::TRequestPtr<NApi::TReqGetTargetState>, NInfra::TReplyPtr<NApi::TRspGetTargetState>) override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NYPUpdatesCoordinator::NDetail
