#pragma once

#include <infra/libs/yp_updates_coordinator/instance_state/state/state.h>

#include <infra/libs/logger/log_frame.h>
#include <infra/libs/sensors/sensor_group.h>

#include <yp/cpp/yp/request_model.h>

#include <util/generic/maybe.h>
#include <util/generic/ptr.h>

namespace NYPUpdatesCoordinator {

namespace NApi {

class TReqGetTargetState;

} // namespace NApi

class ICoordinator: public TThrRefBase {
public:
    ICoordinator();

    ~ICoordinator();

    virtual TMaybe<ui64> GetTargetState(const NApi::TReqGetTargetState& request, const TVector<TInstanceInfo>& instanceInfos, NInfra::TLogFramePtr logFrame, NInfra::TSensorGroup sensorGroup) const = 0;

    void SetYpClient(const NYP::NClient::TClientPtr client);

    ui64 GenerateTimestamp(NInfra::TLogFramePtr logFrame) const;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

using ICoordinatorPtr = TIntrusivePtr<ICoordinator>;

class TFakeCoordinator: public ICoordinator {
public:
    TMaybe<ui64> GetTargetState(const NApi::TReqGetTargetState&, const TVector<TInstanceInfo>&, NInfra::TLogFramePtr, NInfra::TSensorGroup) const override;
};

} // namespace NYPUpdatesCoordinator
