#pragma once

#include "coordinator.h"

#include <infra/libs/yp_updates_coordinator/coordinator/protos/config/config.pb.h>
#include <infra/libs/yp_updates_coordinator/misc/served_service_config/config.pb.h>

#include <infra/libs/logger/log_frame.h>

#include <mapreduce/yt/interface/client.h>

namespace NYPUpdatesCoordinator {

struct TTimestampReelectionOptions {
    TDuration MinAllowedTimeToUpdateSinceReceiving;
    ui32 MinAllowedErrorAttemptsToUpdate = 0;
};

struct TLocationCoordinatorOptions {
    TString Service;
    TVector<TString> Locations;
    TDuration Delay = TDuration::Seconds(5);
    TTimestampReelectionOptions TimestampReelectionOptions;

    TString YtProxy;
    TString CypressRootPath;
    TMaybe<TString> PrimaryMedium;
};

TLocationCoordinatorOptions MakeLocationCoordinatorOptions(const TLocationCoordinatorConfig& config);

TLocationCoordinatorConfig MakeLocationCoordinatorConfig(const TServedServiceConfig& serviceConfig);

TLocationCoordinatorOptions MakeLocationCoordinatorOptions(const TServedServiceConfig& serviceConfig);

class TLocationCoordinator: public ICoordinator {
public:
    TLocationCoordinator(TLocationCoordinatorOptions options);

    TMaybe<ui64> GetTargetState(const NApi::TReqGetTargetState& request, const TVector<TInstanceInfo>& instanceInfos, NInfra::TLogFramePtr logFrame, NInfra::TSensorGroup sensorGroup) const;

private:
    TMaybe<ui64> GetPreviousTimestampByTime(const TString& location, const TDuration& ago, NInfra::TLogFramePtr logFrame) const;

    TMaybe<ui64> GetNextLocationTargetTimestamp(const TVector<TString>::const_iterator locationIt, NInfra::TLogFramePtr logFrame) const;

    TMaybe<ui64> GetLocationTargetTimestamp(const TString& location, NInfra::TLogFramePtr logFrame) const;

    TMaybe<ui64> TryUpdateLocationTargetTimestamp(const TString& location, const ui64 expected, const ui64 target, NInfra::TLogFramePtr logFrame) const;

    void UpdateLocationTimestampInfo(const TString& location, const ui64 timestamp, const TInstant& updateTime, NInfra::TLogFramePtr logFrame) const;

private:
    bool IsTimestampInvalid(const ui64 timestamp, const TVector<TInstanceInfo>& instanceInfos) const;

private:
    void CreateTargetVersionNodes() const;

    void CreateAndMountVersionsTables() const;

private:
    const TLocationCoordinatorOptions Options_;
    const NYT::IClientPtr YtClient_;

    const NYT::TYPath CoordinatorPath_;
};

} // namespace NYPUpdatesCoordinator
