#pragma once

#include <infra/libs/yp_updates_coordinator/api/api.grpc.pb.h>
#include <infra/libs/yp_updates_coordinator/api/api.pb.h>

#include <infra/libs/yp_updates_coordinator/service_iface/service_iface.h>

#include <contrib/libs/grpc/include/grpc++/grpc++.h>

namespace NYPUpdatesCoordinator {

class TGrpcService: public NApi::TYPTimestampProviderService::Service {
public:
    using Status = grpc::Status;
    using ServerContext = grpc::ServerContext;

public:
    TGrpcService(IService& service);

    ~TGrpcService();

    Status GetTargetState(ServerContext*, const NApi::TReqGetTargetState* request, NApi::TRspGetTargetState* response) override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NYPUpdatesCoordinator
