#pragma once

#include <infra/libs/yp_updates_coordinator/instance_state/state/state.h>

#include <infra/libs/logger/log_frame.h>

#include <util/generic/ptr.h>
#include <util/generic/string.h>

namespace NYPUpdatesCoordinator {

struct TInstanceStateReaderOptions {
    TString YtProxy;
    TString YtToken;
    TString CypressRootPath;
    TString Service;
};

class TInstanceStateReader {
public:
    TInstanceStateReader(TInstanceStateReaderOptions options);
    ~TInstanceStateReader();

    TVector<TInstanceInfo> GetInstanceInfos(NInfra::TLogFramePtr logFrame) const;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NYPUpdatesCoordinator
