#pragma once

#include <infra/libs/yp_updates_coordinator/instance_state/state/state.h>

#include <infra/libs/logger/log_frame.h>

#include <library/cpp/yson/node/node.h>

#include <util/datetime/base.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/system/hostname.h>

namespace NYPUpdatesCoordinator::NDetail {

struct TRegistrationOptions {
    bool Register = false;
    bool ParticipateInCoordination = false;
    TString InstanceName = FQDNHostName();
    TDuration LockTimeout = TDuration::Seconds(10);
    TMaybe<NYT::TNode> Meta = Nothing();
};

struct TYtOptions {
    TString YtProxy;
    TString YtToken;
    TString CypressRootPath;
    TString Service;

    TMaybe<TString> PrimaryMedium;
};

struct TInstanceStateClientWriterOptions: public TYtOptions, public TRegistrationOptions {
    TInstanceStateClientWriterOptions()
        : TRegistrationOptions{.Register = true}
    {
    }
};

struct TInstanceStateProviderWriterOptions: public TYtOptions, protected TRegistrationOptions {
    friend struct TInstanceStateBaseWriterOptions;

    TInstanceStateProviderWriterOptions()
        : TRegistrationOptions{.Register = false}
    {
    }
};

struct TInstanceStateBaseWriterOptions: public TYtOptions, public TRegistrationOptions {
    TInstanceStateBaseWriterOptions(TInstanceStateClientWriterOptions clientOptions)
        : TYtOptions(clientOptions)
        , TRegistrationOptions(std::move(clientOptions))
    {
    }

    TInstanceStateBaseWriterOptions(TInstanceStateProviderWriterOptions providerOptions)
        : TYtOptions(providerOptions)
        , TRegistrationOptions(providerOptions)
    {
    }
};

class TInstanceStateBaseWriter {
protected:
    TInstanceStateBaseWriter(TInstanceStateBaseWriterOptions options, NInfra::TLogFramePtr logFrame);
    virtual ~TInstanceStateBaseWriter();

    void StartParticipateInCoordination(NInfra::TLogFramePtr logFrame);

    void WaitForReadiness(NInfra::TLogFramePtr logFrame);

    void UpdateCurrentState(const TTimestampClientInfo& info, NInfra::TLogFramePtr logFrame);
    void UpdateTargetState(const TTimestampClientInfo& info, NInfra::TLogFramePtr logFrame);
    void UpdateSentState(const TString& instanceName, const TTimestampProviderInfo& info, NInfra::TLogFramePtr logFrame);
    void UpdateTimestampUpdateStatus(const ui64 timestamp, TUpdateStatus status, NInfra::TLogFramePtr logFrame);

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

class TInstanceStateClientWriter: public TInstanceStateBaseWriter {
public:
    TInstanceStateClientWriter(TInstanceStateClientWriterOptions options, NInfra::TLogFramePtr logFrame);

    using TInstanceStateBaseWriter::StartParticipateInCoordination;

    using TInstanceStateBaseWriter::WaitForReadiness;

    using TInstanceStateBaseWriter::UpdateCurrentState;
    using TInstanceStateBaseWriter::UpdateTargetState;
    using TInstanceStateBaseWriter::UpdateTimestampUpdateStatus;
};

class TInstanceStateProviderWriter: public TInstanceStateBaseWriter {
public:
    TInstanceStateProviderWriter(TInstanceStateProviderWriterOptions options, NInfra::TLogFramePtr logFrame);

    using TInstanceStateBaseWriter::WaitForReadiness;

    using TInstanceStateBaseWriter::UpdateSentState;
};

} // namespace NYPUpdatesCoordinator::NDetail
