#pragma once

#include <infra/libs/yp_updates_coordinator/api/api.pb.h>
#include <infra/libs/yp_updates_coordinator/instance_state/state/state.h>
#include <infra/libs/yp_updates_coordinator/logger/events/events_decl.ev.pb.h>

#include <infra/libs/service_iface/str_iface.h>

#include <mapreduce/yt/interface/client_method_options.h>
#include <mapreduce/yt/util/wait_for_tablets_state.h>

namespace NYPUpdatesCoordinator {

NEventlog::TAttributes MakeAttributesEvent(const NInfra::TAttributes& attributes);

NEventlog::TGetTargetStateRequest MakeGetTargetStateRequestEvent(const NApi::TReqGetTargetState& request);

NEventlog::TGetTargetStateRequest MakeGetTargetStateRequestEvent(const NApi::TReqGetTargetState& request, const NInfra::TAttributes& attributes);

NEventlog::TGetTargetStateRequest MakeGetTargetStateRequestEvent(NInfra::TRequestPtr<NApi::TReqGetTargetState> request);

NEventlog::TGetTargetStateResponse MakeGetTargetStateResponseEvent(const NApi::TRspGetTargetState& response);

NEventlog::TGetTargetStateResponse MakeGetTargetStateResponseEvent(const NApi::TRspGetTargetState& response, const NInfra::TAttributes& attributes);

NEventlog::TTimestampInfo MakeTimestampInfoEvent();

NEventlog::TInstanceState MakeInstanceStateEvent();

NEventlog::TInstanceInfo MakeInstanceInfoEvent();

NEventlog::TLocationCoordinatorGetTargetState MakeLocationCoordinatorGetTargetStateEvent(const NApi::TReqGetTargetState& request, const TVector<TInstanceInfo>& instanceInfos);

NEventlog::TLocationCoordinatorRequestInstanceInfo MakeLocationCoordinatorRequestInstanceInfoEvent(const TInstanceInfo* instanceInfo);

NEventlog::TLocationCoordinatorRequestInstanceLocationInfo MakeLocationCoordinatorRequestInstanceLocationInfoEvent(
    const TString& location,
    const TMaybe<ui64>& targetTimestamp
);

NEventlog::TLocationCoordinatorRequestInstanceLocationIsInvalid MakeLocationCoordinatorRequestInstanceLocationIsInvalidEvent(
    const TMaybe<TString>& location,
    const TVector<TString>& validLocations
);

NEventlog::TLocationCoordinatorGetNextLocationTargetTimestamp MakeLocationCoordinatorGetNextLocationTargetTimestampEvent(const TString* location);

NEventlog::TLocationCoordinatorGetNextLocationTargetTimestampResult MakeLocationCoordinatorGetNextLocationTargetTimestampResultEvent(
    NEventlog::TLocationCoordinatorGetNextLocationTargetTimestampResult::ESource source,
    const TMaybe<ui64>& targetTimestamp
);

NEventlog::TLocationCoordinatorGetPreviousTimestampByTimeQueryResponse MakeLocationCoordinatorGetPreviousTimestampByTimeQueryResponseEvent(
    const NYT::TNode::TListType& result
);

NEventlog::TLocationCoordinatorSetTargetTimestampToLocationNextTargetTimestamp MakeLocationCoordinatorSetTargetTimestampToLocationNextTargetTimestampEvent(
    const TMaybe<ui64>& locationNextTargetTimestamp
);

NEventlog::TLocationCoordinatorSetTargetTimestampToLocationNewTargetTimestamp MakeLocationCoordinatorSetTargetTimestampToLocationNewTargetTimestampEvent(
    const TMaybe<ui64>& locationNewTargetTimestamp
);

NEventlog::TLocationCoordinatorSetTargetTimestampToInstanceCurrentTimestamp MakeLocationCoordinatorSetTargetTimestampToInstanceCurrentTimestampEvent(
    const TMaybe<ui64>& instanceCurrentTimestamp
);

NEventlog::TLocationCoordinatorGetTargetStateResult MakeLocationCoordinatorGettargetStateResultEvent(const TMaybe<ui64>& timestamp);

NEventlog::TInstanceStateReaderListInstances MakeInstanceStateReaderListInstancesEvent(const TString& path, const NYT::TListOptions& listOptions);

NEventlog::TInstanceStateReaderListPathResult MakeInstanceStateReaderListPathResultEvent(const NYT::TNode::TListType& result);

NEventlog::TInstanceStateReaderListInstancesResult MakeInstanceStateReaderListInstancesResultEvent(const TVector<TInstanceInfo>& instanceInfos);

NEventlog::TInstanceStateReaderFillStatesLookupStateRows MakeInstanceStateReaderFillStatesLookupStateRowsEvent(
    const TString& path,
    const NYT::TNode::TListType& keys,
    const NYT::TLookupRowsOptions& lookupOptions
);

NEventlog::TInstanceStateReaderFillStatesLookupStateRowsResult MakeInstanceStateReaderFillStatesLookupStateRowsResultEvent(const NYT::TNode::TListType& states);

NEventlog::TInstanceStateReaderFillStatesLookupVersionInfosRows MakeInstanceStateReaderFillStatesLookupVersionInfosRowsEvent(
    const TString& path,
    const NYT::TNode::TListType& keys,
    const NYT::TLookupRowsOptions& lookupOptions
);

NEventlog::TInstanceStateReaderFillStatesLookupVersionInfosRowsResult MakeInstanceStateReaderFillStatesLookupVersionInfosRowsResultEvent(
    const NYT::TNode::TListType& versionInfos
);

NEventlog::TInstanceStateReaderFillStatesResult MakeInstanceStateReaderFillStatesResult(const TVector<TInstanceInfo>& instanceInfos);

NEventlog::TInstanceStateWriterUpdateTimestampInfo MakeInstanceStateWriterUpdateTimestampInfoEvent(
    const NYT::TYPath& path,
    const NYT::TNode::TListType& rows,
    const NYT::TInsertRowsOptions& insertOptions
);

NEventlog::TInstanceStateWriterSetTimestamp MakeInstanceStateWriterSetTimestampEvent(
    const NYT::TYPath& path,
    const NYT::TNode::TListType& rows,
    const NYT::TInsertRowsOptions& insertOptions
);

NEventlog::TInstanceStateWriterCreateStateTable MakeInstanceStateWriterCreateStateTableEvent(
    const NYT::TYPath& path,
    const NYT::ENodeType& nodeType,
    const NYT::TCreateOptions& createOptions
);

NEventlog::TInstanceStateWriterWaitForMountedStateTable MakeInstanceStateWriterWaitForMountedStateTableEvent(
    const NYT::TYPath& path,
    const NYT::ETabletState& targetTabletsState,
    const NYT::TWaitForTabletsStateOptions& waitForTabletsStateOptions
);

NEventlog::TInstanceStateWriterCreateVersionsTable MakeInstanceStateWriterCreateVersionsTableEvent(
    const NYT::TYPath& path,
    const NYT::ENodeType& nodeType,
    const NYT::TCreateOptions& createOptions
);

NEventlog::TInstanceStateWriterWaitForMountedVersionsTable MakeInstanceStateWriterWaitForMountedVersionsTableEvent(
    const NYT::TYPath& path,
    const NYT::ETabletState& targetTabletsState,
    const NYT::TWaitForTabletsStateOptions& waitForTabletsStateOptions
);

NEventlog::TInstanceStateWriterCreateInstanceDocument MakeInstanceStateWriterCreateInstanceDocumentEvent(
    const NYT::TYPath& path,
    const NYT::ENodeType& nodeType,
    const NYT::TCreateOptions& createOptions
);

NEventlog::TInstanceStateWriterRemoveInstanceDocument MakeInstanceStateWriterRemoveInstanceDocumentEvent(
    const NYT::TYPath& path,
    const NYT::TRemoveOptions& removeOptions
);

NEventlog::TYPUpdatesCoordinatorClientRequestTargetStateResponse MakeYPUpdatesCoordinatorClientRequestTargetStateResponseEvent(
    const NApi::TRspGetTargetState& response
);

NEventlog::TYPUpdatesCoordinatorClientUpdateTargetState MakeYPUpdatesCoordinatorClientUpdateTargetStateEvent(
    const TTimestampClientInfo& timestampInfo
);

NEventlog::TYPUpdatesCoordinatorGetInstanceName MakeYPUpdatesCoordinatorGetInstanceNameEvent(
    const TMaybe<TString>& optionsInstanceName
);

NEventlog::TProviderClientGetTargetStateRequest MakeProviderClientGetTargetStateRequestEvent(
    const NApi::TReqGetTargetState& request,
    const NInfra::TAttributes& attributes
);

NEventlog::TProviderClientGetTargetStateResponse MakeProviderClientGetTargetStateResponseEvent(
    const NApi::TRspGetTargetState& response,
    const NInfra::TAttributes& attributes
);

} // namespace NYPUpdatesCoordinator
