#pragma once

#include <infra/libs/yp_updates_coordinator/api/api.pb.h>
#include <infra/libs/yp_updates_coordinator/provider/protos/config/config.pb.h>
#include <infra/libs/yp_updates_coordinator/misc/served_service_config/config.pb.h>

#include <infra/libs/yp_updates_coordinator/coordinator/coordinator.h>

#include <infra/libs/logger/log_frame.h>
#include <infra/libs/sensors/sensor_group.h>

#include <yp/cpp/yp/request_model.h>

#include <util/generic/ptr.h>

namespace NYPUpdatesCoordinator {

struct TProviderOptions {
    TString Service;
    TString YtProxy;
    TString CypressRootPath;
    TMaybe<TString> PrimaryMedium;
    NYP::NClient::TClientOptions YpClientOptions;
};

TProviderOptions MakeProviderOptions(const TProviderConfig& config);

TProviderConfig MakeProviderConfig(const TServedServiceConfig& serviceConfig);

TProviderOptions MakeProviderOptions(const TServedServiceConfig& serviceConfig);

class TProvider {
public:
    TProvider(TProviderOptions options, const ICoordinatorPtr coordinator, NInfra::TLogFramePtr initLogFrame);
    ~TProvider();

    ui64 GetTargetState(const NApi::TReqGetTargetState& request, NInfra::TLogFramePtr logFrame, NInfra::TSensorGroup sensorGroup) const;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NYPUpdatesCoordinator
