#include "router_api.h"

#include <infra/libs/service_iface/str_iface.h>

namespace NYPUpdatesCoordinator {

NInfra::TRequestRouterPtr CreateRouter(IApi& service) {
    auto router = MakeSimpleShared<NInfra::TRequestRouter<IApi>>(service);

    (*router)
        .Add<NInfra::TEmptyRequest<NApi::TReqPing>, NInfra::TProto2JsonReply<NApi::TRspPing>>("/ping", "Ping", &IApi::Ping)
        .Add<NInfra::TEmptyRequest<NApi::TReqReopenLog>, NInfra::TProto2JsonReply<NApi::TRspReopenLog>>("/reopen_log", "Reopen logs", &IApi::ReopenLog)
        .Add<NInfra::TEmptyRequest<NApi::TReqSensors>, NInfra::TRawDataReply<NApi::TRspSensors>>("/sensors", "Show sensors", &IApi::Sensors)
        .Add<NInfra::TEmptyRequest<NApi::TReqShutdown>, NInfra::TProto2JsonReply<NApi::TRspShutdown>>("/shutdown", "Shutdown", &IApi::Shutdown)
        .Add<NInfra::TSerializedProtoRequest<NApi::TReqGetTargetState>, NInfra::TSerializedProtoReply<NApi::TRspGetTargetState>>("/get_target_state", "Get YP timestamp", &IApi::GetTargetState)
        .Add<NInfra::TJson2ProtoRequest<NApi::TReqGetTargetState>, NInfra::TProto2JsonReply<NApi::TRspGetTargetState>>("/get_target_state/json", "Get YP timestamp (json)", &IApi::GetTargetState);

    return router;
}

} // namespace NYPUpdatesCoordinator
