#pragma once

#include <infra/libs/sensors/sensor_group.h>

#include <util/generic/strbuf.h>

namespace NYPUpdatesCoordinator::NSensors {

// Sensor groups
static const NInfra::TSensorGroup SERVICE_GROUP = TStringBuf("service");

static const NInfra::TSensorGroup PING_GROUP = NInfra::TSensorGroup{"ping"};
static const NInfra::TSensorGroup REOPEN_LOG_GROUP = NInfra::TSensorGroup{"reopen_log"};
static const NInfra::TSensorGroup SENSORS_GROUP = NInfra::TSensorGroup{"sensors"};
static const NInfra::TSensorGroup SHUTDOWN_GROUP = NInfra::TSensorGroup{"shutdown"};
static const NInfra::TSensorGroup GET_TARGET_STATE_GROUP = NInfra::TSensorGroup{"get_target_state"};

constexpr TStringBuf PROVIDER = "provider";

// Sensors

constexpr TStringBuf REQUESTS = "requests";
constexpr TStringBuf ERRORS = "errors";
constexpr TStringBuf FAILURES = "failures";
constexpr TStringBuf SUCCESSES = "successes";

constexpr TStringBuf PROVIDER_NOT_FOUND = "provider_not_found";

constexpr TStringBuf COORDINATOR_UNDEFINED_TARGET_STATE = "coordinator_undef_target_state";
constexpr TStringBuf SENT_TIMESTAMP = "sent_timestamp";


// Labels

constexpr TStringBuf SERVICE = "service_name";
constexpr TStringBuf INSTANCE_NAME = "instance_name";
constexpr TStringBuf STATUS = "status";

} // namespace NYPUpdatesCoordinator::NSensors
