#pragma once

#include <infra/libs/yp_updates_coordinator/service_iface/service_iface.h>
#include <infra/libs/yp_updates_coordinator/service/protos/config/config.pb.h>

#include <util/generic/ptr.h>

namespace NYPUpdatesCoordinator {

class TService: public IService {
public:
    TService(TServiceConfig config);
    ~TService() override;

    void Start() override;
    void Wait() override;

    void Ping(NInfra::TRequestPtr<NApi::TReqPing> request, NInfra::TReplyPtr<NApi::TRspPing> reply) override;

    void GetTargetState(NInfra::TRequestPtr<NApi::TReqGetTargetState> request, NInfra::TReplyPtr<NApi::TRspGetTargetState> reply) override;

    void ReopenLog(NInfra::TRequestPtr<NApi::TReqReopenLog> request, NInfra::TReplyPtr<NApi::TRspReopenLog> reply) override;

    void Sensors(NInfra::TRequestPtr<NApi::TReqSensors> request, NInfra::TReplyPtr<NApi::TRspSensors> reply) override;

    void Shutdown(NInfra::TRequestPtr<NApi::TReqShutdown> request, NInfra::TReplyPtr<NApi::TRspShutdown> reply) override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NYPUpdatesCoordinator
