#!/usr/bin/env bash

DEPENDENCIES="kernel"

set -e

do_info()
{
    echo " * $*" 
}

do_cleanup()
{
    do_info "cleanup $*"
    if [ "$1" = "full" ]; then
        rm -rf ./build ./snapshot
        find . -name '*.py[co]' -delete
    fi
}

do_prepare() {
    do_info "preparing directories"
    mkdir -p snapshot
}

do_ctl() {
    do_info "adding logger.scsd"
    if [ "$1" = "symlink" ]; then
        cp -f ./logger.scsd snapshot
    else
        cp -f ./logger.scsd snapshot
    fi

    ${PYTHON} -m compileall -q snapshot
}

do_bundle() {
    do_cleanup full
    do_prepare
    do_ctl

    for f in *; do
        case "$f" in
            build.sh|snapshot|build|*.pyc|*.pyo) continue ;;
        esac

        mkdir -p snapshot/service/skynet_logger

        cp -rf "$f" snapshot/service/skynet_logger/
        ${PYTHON} -m compileall -q snapshot
    done
    do_cleanup
}

do_develop() {
    do_cleanup full
    do_prepare
    do_ctl symlink
    mkdir -p snapshot/service
    ln -sf "$(pwd)" snapshot/service/skynet_logger  # make snapshot/skynet_logger link to ourselves
    do_cleanup
}

case "$1" in
    bundl*)     do_bundle             ;;
    dev*)       do_develop            ;;
    clean*)     do_cleanup full       ;;
    dep*)       echo ${DEPENDENCIES}  ;;
    *)          echo "Usage $0 [options] develop | bundle | clean | deps | help" ;;
esac
