import socket
import struct

import six

from functools import partial


class Logger(object):
    struct = struct.Struct('!IIIiI')

    def __init__(self, udp_socket_path):
        self.sock = socket.socket(socket.AF_UNIX, socket.SOCK_DGRAM)
        self.sock.settimeout(1)
        self.closed = False
        self.dest = udp_socket_path

    def close(self):
        self.closed = True
        self.sock.close()

    def log(self, app, namespace, level, message, filename=None):
        max_packet = 2 ** 16 - 28
        if filename is None:
            filename = ''

        if six.PY2 and isinstance(message, six.text_type):
            message = message.encode('utf-8')

        if six.PY3:
            if isinstance(app, six.text_type):
                app = app.encode('utf-8')
            if isinstance(namespace, six.text_type):
                namespace = namespace.encode('utf-8')
            if isinstance(filename, six.text_type):
                filename = filename.encode('utf-8')
            if isinstance(message, six.text_type):
                message = message.encode('utf-8')

        desclen = self.struct.size + len(app) + len(namespace) + len(filename)
        if len(message) + desclen > max_packet:
            message = message[:max_packet - desclen]

        header = self.struct.pack(len(app), len(namespace), len(filename), level, len(message))

        message = b''.join((header, app, namespace, filename, message))

        self.sock.sendto(message, self.dest)


def make_logger_constructor(udp_socket_path):
    return partial(Logger, udp_socket_path)
