import sys
import gevent
import gevent.socket as socket


def main():
    cmd = sys.argv[1]
    sockfile = sys.argv[2]
    sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)

    with gevent.Timeout(30) as tout:
        try:
            sock.connect(sockfile)
            sock.sendall(cmd.upper() + '\n')
            buff = []
            while True:
                ch = sock.recv(1)
                if ch == '\n' or not ch:
                    break
                buff.append(ch)

            data = ''.join(buff)

            if data == 'OKAY':
                return 0

        except gevent.Timeout as ex:
            if ex == tout:
                sys.stderr.write('Timeout: %s\n' % (ex, ))
                return 1
            raise

    return 1


if __name__ == '__main__':
    raise SystemExit(main())
