package main

import (
	"bufio"
	"fmt"
	"os"
	"strings"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/maxwell/go/pkg/maxwell/client"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

var rootCmd = &cobra.Command{
	Use: "maxwell",
}

func Execute() error {
	return rootCmd.Execute()
}

type maxctlConfig struct {
	url string
}

func init() {
	config := &maxctlConfig{
		url: "",
	}

	cmdOAuth := &cobra.Command{
		Use:   "oauth",
		Short: "Get oauth code",
		Args:  cobra.NoArgs,
		Run: func(cmd *cobra.Command, args []string) {
			var m client.Maxwell
			var err error
			l, _ := zap.New(zap.CLIConfig(log.DebugLevel))
			if config.url == "" {
				m, err = client.CreateMaxwell(URLProduction, "", l)
			} else {
				m, err = client.CreateMaxwell(config.url, "", l)
			}
			if err != nil {
				er(err)
			}
			fmt.Println("Enter code from https://oauth.yandex-team.ru/authorize?response_type=code&client_id=ba346d6968814c258fdcd450cb0a3610")
			reader := bufio.NewReader(os.Stdin)
			code, err := reader.ReadString('\n')
			code = strings.Replace(code, "\n", "", -1)
			if err != nil {
				er(err)
			}
			resp, err := m.GetOAuth(code)
			if err != nil {
				er(err)
			}
			fmt.Println("Add this token to env 'export MAXWELL_TOKEN=AQAD***********'")
			fmt.Println(resp)
		},
	}

	registerJobs(rootCmd, config)
	registerSpecs(rootCmd, config)
	RegisterPrepare(rootCmd)

	rootCmd.AddCommand(cmdOAuth)
	rootCmd.PersistentFlags().StringVar(&config.url, "url", "", "Maxwell url")
}

func getMaxwellTokenFromEnv() string {
	return os.Getenv("MAXWELL_TOKEN")
}

func er(msg interface{}) {
	fmt.Println("Error:", msg)
	os.Exit(1)
}
