package main

import (
	"fmt"
	"strings"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/maxwell/go/internal/pool"
	"a.yandex-team.ru/infra/maxwell/go/internal/storages"
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
	"a.yandex-team.ru/infra/maxwell/go/pkg/yamlutils"
	pb "a.yandex-team.ru/infra/maxwell/go/proto"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

func RegisterPrepare(root *cobra.Command) {
	cmdPrepare := &cobra.Command{
		Use:   "prepare <spec.yaml>",
		Short: "Prepare queue of groups",
		Args:  cobra.ExactArgs(1),
		Run: func(cmd *cobra.Command, args []string) {
			spec := &pb.Job_Spec{}
			specPath := args[0]
			if err := yamlutils.ReadFromFile(specPath, spec); err != nil {
				er(err)
			}
			p := pool.New(spec, storages.NewJobInMemory(), storages.NewNannyServicesInMemory(), storages.NewYpNodesInMemory())
			api := walle.NewAPIClient(walle.URLProduction, "")
			w := walle.NewClient(api)
			l, _ := zap.New(zap.CLIConfig(log.InfoLevel))
			if err := p.Update(w, l, make([]string, 0)); err != nil {
				er(err)
			}
			groups := p.Group()
			b := &strings.Builder{}
			for _, groupName := range p.GroupOrder() {
				b.WriteString(fmt.Sprintf("  Group: '%s'\n", groupName))
				for _, hostname := range groups[groupName] {
					b.WriteString(fmt.Sprintf("  - %s\n", hostname))
				}
			}
			l.Infof("Groups: \n%s", b.String())
		},
	}
	root.AddCommand(cmdPrepare)
}
