package main

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/maxwell/go/pkg/maxwell/server"
)

var rootCmd = &cobra.Command{
	Use: "maxwell-server",
}

func Execute() error {
	return rootCmd.Execute()
}

func init() {
	var walleTokenCLI string

	c := &server.MaxwellConfig{
		Addr:     server.Addr,
		Insecure: false,
	}
	cmdStart := &cobra.Command{
		Use: "start",
		Short: "Start Maxwell\n" +
			"Maxwell will fetch and redeploy hosts with old distribs with with specs from `spec` dir",
		Args: cobra.NoArgs,
		RunE: func(cmd *cobra.Command, args []string) error {
			if walleTokenCLI == "" {
				c.WalleToken = getWalleTokenFromEnv()
			} else {
				c.WalleToken = walleTokenCLI
			}
			c.NannyToken = getNannyTokenFromEnv()
			c.YpToken = getYPTokenFromEnv()
			c.Debug = getDebugFromEnv()
			c.ClientID, c.ClientSecret = getClientIDAndSecret()
			mw, err := server.CreateMaxwell(c)
			if err != nil {
				return err
			}
			return mw.Start()
		},
	}
	f := cmdStart.Flags()
	f.StringVar(&c.SpecsPath, "spec", "", "Path to job spec")
	f.BoolVar(&c.InMemory, "inMemory", false,
		"If true will not connect to database and will create inMemory storages")
	f.StringVar(&c.Addr, "addr", server.Addr, "server address")
	rootCmd.AddCommand(cmdStart)
	rootCmd.PersistentFlags().StringVar(&walleTokenCLI, "token", "", "Wall-E access token. Default: from env 'WALLE_TOKEN'")
	rootCmd.PersistentFlags().BoolVar(&c.Insecure, "insecure", false, "Insecure mode: will not check auth with bb")
	rootCmd.PersistentFlags().BoolVar(&c.DryRun, "dry-run", false, "Do not create real tasks in wall-e")
	rootCmd.PersistentFlags().StringVar(&c.Hostname, "hostname", "-", "Hostname")
}

func getWalleTokenFromEnv() string {
	return os.Getenv("WALLE_TOKEN")
}

func getNannyTokenFromEnv() string {
	return os.Getenv("NANNY_TOKEN")
}

func getYPTokenFromEnv() string {
	return os.Getenv("YP_TOKEN")
}

func getDebugFromEnv() bool {
	return os.Getenv("DEBUG") == "true"
}

func getClientIDAndSecret() (string, string) {
	return os.Getenv("CLIENT_ID"), os.Getenv("CLIENT_SECRET")
}

func er(msg interface{}) {
	fmt.Println("Error:", msg)
	os.Exit(1)
}
