package api

import (
	"encoding/json"
	"net/http"
	"strconv"

	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/unistat"
)

type UnistatHandler struct {
	l log.Logger
}

func NewUnistat(l log.Logger) *UnistatHandler {
	return &UnistatHandler{
		l: l,
	}
}

func (u *UnistatHandler) Handle(w http.ResponseWriter, r *http.Request) {
	jobsMetrics, err := unistat.MarshalJSON()
	if err != nil {
		internalError(err, w)
		return
	}
	metrics := make([]interface{}, 0)
	err = json.Unmarshal(jobsMetrics, &metrics)
	if err != nil {
		internalError(err, w)
		return
	}
	buf, err := json.Marshal(metrics)
	if err != nil {
		internalError(err, w)
		return
	}
	w.Header().Set("Content-Type", "application/json")
	w.Header().Set("Content-Length", strconv.Itoa(len(buf)))
	if _, err := w.Write(buf); err != nil {
		u.l.Errorf("Failed to write response: %e", err)
	}
}

func (u *UnistatHandler) Register(mux *chi.Mux) {
	mux.Get("/unistat", u.Handle)
}
